package com.ejie.ab04b.control;

import com.ejie.ab04b.model.comun.Elemento;

/**
 * Enumeration con los eventos posibles
 * 
 * @author Alberto_Diez
 * 
 */
public enum EstadosSolicitud {

	ABIERTA, // Se abre el formulario de la solicitud
	BORRADOR, // Se guarda la solicitud como borrador
	ENVIADA, // Se finaliza el asistente de la solicitud
	PLANTILLA, // PLANTILLA
	SOLICITADA, // Platea confirma mediante evento R02_REQUEST que ha finalizado
	// los trabajos asíncronos de la solicitud

	PROCESADA, // Se procesa la solicitud desde la intranet
	BAJA 
 /**
  * Instantiates a new estados solicitud.
  */
 // Se da de baja la solicitud
	;

	// constructor interno
	/**
	 * 
	 */
	private EstadosSolicitud() {
	}

	/**
	 * Value.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	public String value() {
		return EstadosSolicitudImpl.getInstance().getValue(this.name())
				.getClave();
	}

	/**
	 * Elemento.
	 * 
	 *  String
	 *
	 * @return the elemento
	 */
	public Elemento elemento() {
		return EstadosSolicitudImpl.getInstance().getValue(this.name());
	}

}
